/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate;

import com.github.fge.uritemplate.URITemplateException;
import com.github.fge.uritemplate.URITemplateParseException;
import com.github.fge.uritemplate.expression.URITemplateExpression;
import com.github.fge.uritemplate.parse.URITemplateParser;
import com.github.fge.uritemplate.vars.VariableMap;
import com.github.fge.uritemplate.vars.VariableMapBuilder;
import com.github.fge.uritemplate.vars.values.VariableValue;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public final class URITemplate {
    private final List<URITemplateExpression> expressions;

    public URITemplate(String input) throws URITemplateParseException {
        this.expressions = URITemplateParser.parse(input);
    }

    @Deprecated
    public String expand(Map<String, VariableValue> vars) throws URITemplateException {
        VariableMapBuilder builder = VariableMap.newBuilder();
        for (Map.Entry<String, VariableValue> entry : vars.entrySet()) {
            builder.addValue(entry.getKey(), entry.getValue());
        }
        return this.toString(builder.freeze());
    }

    public String toString(VariableMap vars) throws URITemplateException {
        StringBuilder sb = new StringBuilder();
        for (URITemplateExpression expression : this.expressions) {
            sb.append(expression.expand(vars));
        }
        return sb.toString();
    }

    public URI toURI(VariableMap vars) throws URITemplateException, URISyntaxException {
        return new URI(this.toString(vars));
    }

    public URL toURL(VariableMap vars) throws URITemplateException, MalformedURLException {
        return new URL(this.toString(vars));
    }
}

