/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.render;

import com.github.fge.uritemplate.URITemplateException;
import com.github.fge.uritemplate.expression.ExpressionType;
import com.github.fge.uritemplate.render.ValueRenderer;
import com.github.fge.uritemplate.vars.specs.VariableSpec;
import com.github.fge.uritemplate.vars.values.VariableValue;
import com.google.common.base.Joiner;
import java.util.List;

public abstract class MultiValueRenderer
extends ValueRenderer {
    protected static final Joiner COMMA = Joiner.on((char)',');

    protected MultiValueRenderer(ExpressionType type) {
        super(type);
    }

    @Override
    public final List<String> render(VariableSpec varspec, VariableValue value) throws URITemplateException {
        if (varspec.getPrefixLength() != -1) {
            throw new URITemplateException("incompatible varspec/value combination");
        }
        String varname = varspec.getName();
        if (this.named) {
            return varspec.isExploded() ? this.renderNamedExploded(varname, value) : this.renderNamedNormal(varname, value);
        }
        return varspec.isExploded() ? this.renderUnnamedExploded(value) : this.renderUnnamedNormal(value);
    }

    protected abstract List<String> renderNamedExploded(String var1, VariableValue var2);

    protected abstract List<String> renderUnnamedExploded(VariableValue var1);

    protected abstract List<String> renderNamedNormal(String var1, VariableValue var2);

    protected abstract List<String> renderUnnamedNormal(VariableValue var1);
}

