/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.vars.specs;

import com.github.fge.uritemplate.URITemplateException;
import com.github.fge.uritemplate.expression.ExpressionType;
import com.github.fge.uritemplate.vars.specs.VariableSpecType;
import com.github.fge.uritemplate.vars.values.VariableValue;
import com.google.common.base.CharMatcher;
import com.google.common.primitives.UnsignedBytes;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public abstract class VariableSpec {
    protected static final EnumSet<ExpressionType> PARAM_STYLE_EXPRESSIONS = EnumSet.of(ExpressionType.PATH_PARAMETERS, ExpressionType.QUERY_STRING, ExpressionType.QUERY_CONT);
    private static final CharMatcher UNRESERVED;
    private static final CharMatcher RESERVED_PLUS_UNRESERVED;
    protected final VariableSpecType type;
    protected final String name;

    protected VariableSpec(VariableSpecType type, String name) {
        this.type = type;
        this.name = name;
    }

    public final VariableSpecType getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final String render(ExpressionType type, VariableValue value) throws URITemplateException {
        switch (value.getType()) {
            case SCALAR: {
                return this.renderScalar(type, value.getScalarValue());
            }
            case ARRAY: {
                return this.renderList(type, value.getListValue());
            }
            case MAP: {
                return this.renderMap(type, value.getMapValue());
            }
        }
        throw new RuntimeException("How did I get there?");
    }

    protected abstract String renderScalar(ExpressionType var1, String var2) throws URITemplateException;

    protected abstract String renderList(ExpressionType var1, List<String> var2) throws URITemplateException;

    protected abstract String renderMap(ExpressionType var1, Map<String, String> var2) throws URITemplateException;

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    protected static String expandString(ExpressionType type, String s) {
        CharMatcher matcher = type.isRawExpand() ? RESERVED_PLUS_UNRESERVED : UNRESERVED;
        StringBuilder sb = new StringBuilder(s.length());
        for (char c : s.toCharArray()) {
            sb.append(matcher.matches(c) ? Character.valueOf(c) : VariableSpec.pctEncode(c));
        }
        return sb.toString();
    }

    private static String pctEncode(char c) {
        String tmp = new String(new char[]{c});
        byte[] bytes = tmp.getBytes(Charset.forName("UTF-8"));
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append('%').append(UnsignedBytes.toString((byte)b, (int)16));
        }
        return sb.toString();
    }

    static {
        CharMatcher reserved = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"-._~"));
        CharMatcher genDelims = CharMatcher.anyOf((CharSequence)":/?#[]@");
        CharMatcher subDelims = CharMatcher.anyOf((CharSequence)"!$&'()*+,;=");
        UNRESERVED = reserved.precomputed();
        RESERVED_PLUS_UNRESERVED = reserved.or(genDelims).or(subDelims).precomputed();
    }
}

