/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.msgsimple.source;

import com.github.fge.msgsimple.source.MessageSource;
import java.util.HashMap;
import java.util.Map;

public final class MapMessageSource
implements MessageSource {
    private final Map<String, String> messages;

    public MapMessageSource(Map<String, String> messages) {
        MapMessageSource.checkMap(messages);
        this.messages = new HashMap<String, String>(messages);
    }

    @Override
    public String getKey(String key) {
        return this.messages.get(key);
    }

    private static void checkMap(Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("null map is not allowed");
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey() == null) {
                throw new NullPointerException("null keys not allowed in map");
            }
            if (entry.getValue() != null) continue;
            throw new NullPointerException("null values not allowed in map");
        }
    }
}

