/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.msgsimple.bundle;

import com.github.fge.msgsimple.source.MessageSource;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MessageBundle {
    private final List<MessageSource> sources;

    private MessageBundle(Builder builder) {
        this.sources = new ArrayList<MessageSource>(builder.sources);
    }

    public String getKey(String key) {
        if (key == null) {
            throw new NullPointerException("cannot query null key");
        }
        for (MessageSource source : this.sources) {
            String ret = source.getMessage(key);
            if (ret == null) continue;
            return ret;
        }
        return key;
    }

    public Builder copy() {
        return new Builder(this);
    }

    @NotThreadSafe
    public static final class Builder {
        private final List<MessageSource> sources = new ArrayList<MessageSource>();

        public Builder() {
        }

        private Builder(MessageBundle bundle) {
            this.sources.addAll(bundle.sources);
        }

        public Builder appendSource(MessageSource source) {
            if (source == null) {
                throw new NullPointerException("cannot append null message source");
            }
            this.sources.add(source);
            return this;
        }

        public Builder prependSource(MessageSource source) {
            if (source == null) {
                throw new NullPointerException("cannot prepend null message source");
            }
            this.sources.add(0, source);
            return this;
        }

        public MessageBundle build() {
            return new MessageBundle(this);
        }
    }
}

