/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jsonschema.exceptions.ExceptionProvider;
import com.github.fge.jsonschema.exceptions.InvalidInstanceException;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.Collection;

public abstract class AbstractKeywordValidator
implements KeywordValidator {
    private static final ExceptionProvider EXCEPTION_PROVIDER = new ExceptionProvider(){

        @Override
        public ProcessingException doException(ProcessingMessage message) {
            return new InvalidInstanceException(message);
        }
    };
    protected final String keyword;

    protected AbstractKeywordValidator(String keyword) {
        this.keyword = keyword;
    }

    protected final ProcessingMessage newMsg(FullData data) {
        return data.newMessage().put("domain", "validation").put("keyword", this.keyword).setExceptionProvider(EXCEPTION_PROVIDER);
    }

    protected final ProcessingMessage newMsg(FullData data, MessageBundle bundle, String key) {
        return data.newMessage().put("domain", "validation").put("keyword", this.keyword).setMessage(bundle.getMessage(key)).setExceptionProvider(EXCEPTION_PROVIDER);
    }

    protected static <T> JsonNode toArrayNode(Collection<T> collection) {
        ArrayNode node = JacksonUtils.nodeFactory().arrayNode();
        for (T element : collection) {
            node.add(element.toString());
        }
        return node;
    }

    public abstract String toString();
}

