/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.messages.FormatMessages;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.report.ProcessingReport;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class DateFormatAttribute
extends AbstractFormatAttribute {
    private final String format;
    private final DateTimeFormatter formatter;

    protected DateFormatAttribute(String fmt, String format) {
        super(fmt, NodeType.STRING, new NodeType[0]);
        this.format = format;
        this.formatter = DateTimeFormat.forPattern((String)format);
    }

    @Override
    public final void validate(ProcessingReport report, FullData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        try {
            this.formatter.parseDateTime(instance.textValue());
        }
        catch (IllegalArgumentException ignored) {
            report.error(this.newMsg(data, FormatMessages.INVALID_DATE_FORMAT).put("expected", this.format));
        }
    }
}

