/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.google.common.collect.ImmutableList;
import java.util.Collections;

public final class ArraySchemaSelector {
    private static final JsonPointer ITEMS = JsonPointer.of((Object)"items", (Object[])new Object[0]);
    private static final JsonPointer ADDITIONAL_ITEMS = JsonPointer.of((Object)"additionalItems", (Object[])new Object[0]);
    private final boolean hasItems;
    private final boolean itemsIsArray;
    private final int itemsSize;
    private final boolean hasAdditional;

    public ArraySchemaSelector(JsonNode digest) {
        this.hasItems = digest.get("hasItems").booleanValue();
        this.itemsIsArray = digest.get("itemsIsArray").booleanValue();
        this.itemsSize = digest.get("itemsSize").intValue();
        this.hasAdditional = digest.get("hasAdditional").booleanValue();
    }

    public Iterable<JsonPointer> selectSchemas(int index) {
        if (!this.hasItems) {
            return this.hasAdditional ? ImmutableList.of((Object)ADDITIONAL_ITEMS) : Collections.emptyList();
        }
        if (!this.itemsIsArray) {
            return ImmutableList.of((Object)ITEMS);
        }
        if (index < this.itemsSize) {
            return ImmutableList.of((Object)ITEMS.append(index));
        }
        return this.hasAdditional ? ImmutableList.of((Object)ADDITIONAL_ITEMS) : Collections.emptyList();
    }
}

