/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.tree;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.load.Dereferencing;
import com.github.fge.jsonschema.ref.JsonFragment;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.tree.BaseSchemaTree;
import com.github.fge.jsonschema.tree.SchemaTree;

public final class CanonicalSchemaTree
extends BaseSchemaTree {
    public CanonicalSchemaTree(JsonNode baseNode) {
        this(JsonRef.emptyRef(), baseNode);
    }

    public CanonicalSchemaTree(JsonRef loadingRef, JsonNode baseNode) {
        this(loadingRef, baseNode, JsonPointer.empty(), false);
    }

    private CanonicalSchemaTree(JsonRef loadingRef, JsonNode baseNode, JsonPointer pointer, boolean valid) {
        super(loadingRef, baseNode, pointer, Dereferencing.CANONICAL, valid);
    }

    @Override
    public SchemaTree append(JsonPointer pointer) {
        return new CanonicalSchemaTree(this.loadingRef, this.baseNode, this.pointer.append(pointer), this.valid);
    }

    @Override
    public SchemaTree setPointer(JsonPointer pointer) {
        return new CanonicalSchemaTree(this.loadingRef, this.baseNode, pointer, this.valid);
    }

    @Override
    public boolean containsRef(JsonRef ref) {
        return this.loadingRef.contains(ref);
    }

    @Override
    public JsonPointer matchingPointer(JsonRef ref) {
        JsonFragment fragment = ref.getFragment();
        return fragment.resolve(this.baseNode).isMissingNode() ? null : (JsonPointer)fragment;
    }

    @Override
    public SchemaTree withValidationStatus(boolean valid) {
        return new CanonicalSchemaTree(this.loadingRef, this.baseNode, this.pointer, valid);
    }
}

