/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.cfg;

import com.github.fge.jsonschema.cfg.RefSanityChecks;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.exceptions.unchecked.ValidationConfigurationError;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.library.SchemaVersion;
import com.github.fge.jsonschema.messages.ConfigurationMessages;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.util.Thawed;
import com.google.common.collect.Maps;
import java.util.Map;

public final class ValidationConfigurationBuilder
implements Thawed<ValidationConfiguration> {
    final Map<JsonRef, Library> libraries;
    Library defaultLibrary = SchemaVersion.DRAFTV4.getLibrary();
    boolean useFormat = true;

    ValidationConfigurationBuilder() {
        this.libraries = Maps.newHashMap();
        for (SchemaVersion version : SchemaVersion.values()) {
            this.libraries.put(version.getLocation(), version.getLibrary());
        }
    }

    ValidationConfigurationBuilder(ValidationConfiguration cfg) {
        this.libraries = Maps.newHashMap(cfg.libraries);
        this.defaultLibrary = cfg.defaultLibrary;
        this.useFormat = cfg.useFormat;
    }

    public ValidationConfigurationBuilder addLibrary(String uri, Library library) {
        JsonRef ref = RefSanityChecks.absoluteRef(uri);
        if (library == null) {
            throw new ValidationConfigurationError(new ProcessingMessage().message(ConfigurationMessages.NULL_LIBRARY));
        }
        if (this.libraries.containsKey(ref)) {
            throw new ValidationConfigurationError(new ProcessingMessage().message(ConfigurationMessages.DUP_LIBRARY).put("uri", ref));
        }
        this.libraries.put(ref, library);
        return this;
    }

    public ValidationConfigurationBuilder setDefaultVersion(SchemaVersion version) {
        this.defaultLibrary = version.getLibrary();
        return this;
    }

    public ValidationConfigurationBuilder setDefaultLibrary(String uri, Library library) {
        this.addLibrary(uri, library);
        this.defaultLibrary = library;
        return this;
    }

    public ValidationConfigurationBuilder useFormat(boolean useFormat) {
        this.useFormat = useFormat;
        return this;
    }

    @Override
    public ValidationConfiguration freeze() {
        return new ValidationConfiguration(this);
    }
}

