/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processing;

import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.google.common.base.Equivalence;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;

public final class ProcessingCache<K, V> {
    private final LoadingCache<Equivalence.Wrapper<K>, V> cache;
    private final Equivalence<K> equivalence;

    public ProcessingCache(Equivalence<K> equivalence, CacheLoader<Equivalence.Wrapper<K>, V> cacheLoader) {
        this.equivalence = equivalence;
        this.cache = CacheBuilder.newBuilder().build(cacheLoader);
    }

    public V get(K key) throws ProcessingException {
        try {
            return (V)this.cache.get((Object)this.equivalence.wrap(key));
        }
        catch (ExecutionException e) {
            throw (ProcessingException)e.getCause();
        }
    }

    public V getUnchecked(K key) {
        return (V)this.cache.getUnchecked((Object)this.equivalence.wrap(key));
    }

    public String toString() {
        return this.cache.stats().toString();
    }
}

