/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.ValidationData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.RhinoHelper;

public final class PatternValidator
extends AbstractKeywordValidator {
    public PatternValidator(JsonNode digest) {
        super("pattern");
    }

    @Override
    public void validate(Processor<ValidationData, ProcessingReport> processor, ProcessingReport report, ValidationData data) throws ProcessingException {
        String value;
        String regex = data.getSchema().getNode().get(this.keyword).textValue();
        if (!RhinoHelper.regMatch(regex, value = data.getInstance().getNode().textValue())) {
            report.error(this.newMsg(data).message(KeywordValidationMessages.REGEX_NO_MATCH).put("regex", regex).put("string", value));
        }
    }

    @Override
    public String toString() {
        return this.keyword;
    }
}

