/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.digest.helpers.IdentityDigester;
import com.github.fge.jsonschema.keyword.digest.helpers.SimpleDigester;
import com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.library.Keyword;
import com.github.fge.jsonschema.util.Digester;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.util.Thawed;
import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;

public final class KeywordBuilder
implements Thawed<Keyword> {
    final String name;
    SyntaxChecker syntaxChecker;
    Digester digester;
    Constructor<? extends KeywordValidator> constructor;

    KeywordBuilder(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"a keyword must have a name");
    }

    KeywordBuilder(Keyword keyword) {
        this.name = keyword.name;
        this.syntaxChecker = keyword.syntaxChecker;
        this.digester = keyword.digester;
        this.constructor = keyword.constructor;
    }

    KeywordBuilder withSyntaxChecker(SyntaxChecker syntaxChecker) {
        this.syntaxChecker = (SyntaxChecker)Preconditions.checkNotNull((Object)syntaxChecker, (Object)"syntax checker must not be null");
        return this;
    }

    KeywordBuilder withDigester(Digester digester) {
        this.digester = (Digester)Preconditions.checkNotNull((Object)digester, (Object)"digester must not be null");
        return this;
    }

    KeywordBuilder withIdentityDigester(NodeType first, NodeType ... other) {
        this.digester = new IdentityDigester(this.name, first, other);
        return this;
    }

    KeywordBuilder withSimpleDigester(NodeType first, NodeType ... other) {
        this.digester = new SimpleDigester(this.name, first, other);
        return this;
    }

    KeywordBuilder withValidatorClass(Class<? extends KeywordValidator> c) {
        this.constructor = KeywordBuilder.getConstructor(c);
        return this;
    }

    @Override
    public Keyword freeze() {
        return new Keyword(this);
    }

    private static Constructor<? extends KeywordValidator> getConstructor(Class<? extends KeywordValidator> c) {
        try {
            return c.getConstructor(JsonNode.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No appropriate constructor", e);
        }
    }
}

