/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.syntax.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.NodeType;
import java.util.Collection;

public final class PositiveIntegerSyntaxChecker
extends AbstractSyntaxChecker {
    public PositiveIntegerSyntaxChecker(String keyword) {
        super(keyword, NodeType.INTEGER, new NodeType[0]);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree);
        if (!node.canConvertToInt()) {
            report.error(this.newMsg(tree, SyntaxMessages.INTEGER_TOO_LARGE).put("max", Integer.MAX_VALUE));
            return;
        }
        if (node.intValue() < 0) {
            report.error(this.newMsg(tree, SyntaxMessages.INTEGER_IS_NEGATIVE));
        }
    }
}

