/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.digest.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import com.github.fge.jsonschema.util.Digester;
import com.github.fge.jsonschema.util.JacksonUtils;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public final class DraftV4DependenciesDigester
extends AbstractDigester {
    private static final Digester INSTANCE = new DraftV4DependenciesDigester();

    public static Digester getInstance() {
        return INSTANCE;
    }

    private DraftV4DependenciesDigester() {
        super("dependencies", NodeType.OBJECT, new NodeType[0]);
    }

    @Override
    public JsonNode digest(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        ObjectNode propertyDeps = FACTORY.objectNode();
        ret.put("propertyDeps", (JsonNode)propertyDeps);
        ArrayNode schemaDeps = FACTORY.arrayNode();
        ret.put("schemaDeps", (JsonNode)schemaDeps);
        ArrayList list = Lists.newArrayList();
        Map<String, JsonNode> map = JacksonUtils.asMap(schema.get(this.keyword));
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            String key = entry.getKey();
            JsonNode value = entry.getValue();
            if (value.isObject()) {
                list.add(key);
                continue;
            }
            propertyDeps.put(key, DraftV4DependenciesDigester.sortedSet(value));
        }
        for (String s : Ordering.natural().sortedCopy((Iterable)list)) {
            schemaDeps.add(s);
        }
        return ret;
    }

    private static JsonNode sortedSet(JsonNode node) {
        ArrayList list = Lists.newArrayList((Iterable)node);
        Collections.sort(list, new Comparator<JsonNode>(){

            @Override
            public int compare(JsonNode o1, JsonNode o2) {
                return o1.textValue().compareTo(o2.textValue());
            }
        });
        ArrayNode ret = FACTORY.arrayNode();
        ret.addAll((Collection)list);
        return ret;
    }
}

