/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processing;

import com.github.fge.jsonschema.processing.LogLevel;
import com.github.fge.jsonschema.report.ProcessingMessage;

public final class ProcessingException
extends Exception {
    private final ProcessingMessage processingMessage;

    public ProcessingException() {
        this(new ProcessingMessage());
    }

    public ProcessingException(String message) {
        this(new ProcessingMessage().msg(message));
    }

    public ProcessingException(ProcessingMessage processingMessage) {
        this.processingMessage = processingMessage.setLogLevel(LogLevel.FATAL);
    }

    public ProcessingException(String message, Throwable e) {
        this.processingMessage = new ProcessingMessage().setLogLevel(LogLevel.FATAL).msg(message).put("exceptionClass", e.getClass().getName()).put("exceptionMessage", e.getMessage());
    }

    @Override
    public String getMessage() {
        return this.processingMessage.toString();
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public ProcessingMessage getProcessingMessage() {
        return this.processingMessage;
    }
}

