/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.tree;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.main.JsonSchemaException;
import com.github.fge.jsonschema.processing.ref.Dereferencing;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.tree.BaseJsonTree;
import com.google.common.collect.Queues;
import java.util.Deque;

public abstract class JsonSchemaTree
extends BaseJsonTree {
    private final Dereferencing dereferencing;
    protected final JsonRef loadingRef;
    protected final JsonRef startingRef;
    protected final Deque<JsonRef> refStack = Queues.newArrayDeque();
    protected JsonRef currentRef;

    protected JsonSchemaTree(JsonRef loadingRef, JsonNode baseNode, Dereferencing dereferencing) {
        super(baseNode);
        this.dereferencing = dereferencing;
        this.loadingRef = this.currentRef = loadingRef;
        JsonRef ref = JsonSchemaTree.idFromNode(baseNode);
        if (ref != null) {
            this.currentRef = this.currentRef.resolve(ref);
        }
        this.startingRef = this.currentRef;
    }

    @Override
    public final void append(JsonPointer ptr) {
        this.refStack.push(this.currentRef);
        this.currentRef = JsonSchemaTree.nextRef(this.currentRef, ptr.asElements(), this.currentNode);
        this.pushPointer(this.currentPointer.append(ptr));
        this.pushNode(ptr.resolve(this.currentNode));
    }

    @Override
    public final void pop() {
        this.currentRef = this.refStack.pop();
        this.popPointer();
        this.popNode();
    }

    public final void setPointer(JsonPointer pointer) {
        this.refStack.push(this.currentRef);
        this.currentRef = JsonSchemaTree.nextRef(this.startingRef, pointer.asElements(), this.baseNode);
        this.pushPointer(pointer);
        this.pushNode(pointer.resolve(this.baseNode));
    }

    public final JsonRef resolve(JsonRef other) {
        return this.currentRef.resolve(other);
    }

    public abstract boolean containsRef(JsonRef var1);

    public abstract JsonPointer matchingPointer(JsonRef var1);

    public final JsonRef getLoadingRef() {
        return this.loadingRef;
    }

    public final JsonRef getCurrentRef() {
        return this.currentRef;
    }

    public final JsonSchemaTree copy() {
        JsonSchemaTree ret = this.dereferencing.newTree(this.loadingRef, this.baseNode);
        ret.currentRef = this.currentRef;
        ret.currentPointer = this.currentPointer;
        ret.currentNode = this.currentNode;
        return ret;
    }

    protected static JsonRef idFromNode(JsonNode node) {
        if (!node.path("id").isTextual()) {
            return null;
        }
        try {
            return JsonRef.fromString(node.get("id").textValue());
        }
        catch (JsonSchemaException ignored) {
            return null;
        }
    }

    private static JsonRef nextRef(JsonRef startingRef, Iterable<JsonPointer> pointers, JsonNode startingNode) {
        JsonRef ret = startingRef;
        JsonNode node = startingNode;
        for (JsonPointer pointer : pointers) {
            node = pointer.resolve(node);
            JsonRef idRef = JsonSchemaTree.idFromNode(node);
            if (idRef == null) continue;
            ret = ret.resolve(idRef);
        }
        return ret;
    }

    @Override
    public final JsonNode asJson() {
        ObjectNode ret = FACTORY.objectNode();
        ret.put("loadingURI", (JsonNode)FACTORY.textNode(this.loadingRef.toString()));
        ret.put("pointer", (JsonNode)FACTORY.textNode(this.currentPointer.toString()));
        ret.put("currentContext", (JsonNode)FACTORY.textNode(this.currentRef.toString()));
        ret.put("dereferencing", (JsonNode)FACTORY.textNode(this.dereferencing.toString()));
        return ret;
    }

    @Override
    public final String toString() {
        return this.asJson().toString();
    }
}

