/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processing.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ValidationData;
import com.github.fge.jsonschema.processing.build.FullValidationContext;
import com.github.fge.jsonschema.processing.validation.ArraySchemaDigester;
import com.github.fge.jsonschema.processing.validation.ArraySchemaSelector;
import com.github.fge.jsonschema.processing.validation.ObjectSchemaDigester;
import com.github.fge.jsonschema.processing.validation.ObjectSchemaSelector;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.JsonSchemaTree;
import com.github.fge.jsonschema.tree.JsonTree;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public final class ValidationProcessor
implements Processor<ValidationData, ProcessingReport> {
    private final Processor<ValidationData, FullValidationContext> processor;
    private final LoadingCache<JsonNode, ArraySchemaSelector> arrayCache;
    private final LoadingCache<JsonNode, ObjectSchemaSelector> objectCache;

    public ValidationProcessor(Processor<ValidationData, FullValidationContext> processor) {
        this.processor = processor;
        this.arrayCache = CacheBuilder.newBuilder().build(ValidationProcessor.arrayLoader());
        this.objectCache = CacheBuilder.newBuilder().build(ValidationProcessor.objectLoader());
    }

    @Override
    public ProcessingReport process(ProcessingReport report, ValidationData input) throws ProcessingException {
        FullValidationContext context = this.processor.process(report, input);
        ValidationData data = context.getValidationData();
        for (KeywordValidator validator : context) {
            validator.validate(this, report, data);
        }
        JsonNode node = input.getInstance().getCurrentNode();
        if (node.size() == 0) {
            return report;
        }
        if (node.isArray()) {
            this.processArray(report, input);
        } else {
            this.processObject(report, input);
        }
        return report;
    }

    private void processArray(ProcessingReport report, ValidationData input) throws ProcessingException {
        JsonSchemaTree schemaTree = input.getSchema();
        JsonTree tree = input.getInstance();
        JsonNode schema = schemaTree.getCurrentNode();
        JsonNode instance = tree.getCurrentNode();
        JsonNode digest = ArraySchemaDigester.getInstance().digest(schema);
        ArraySchemaSelector selector = (ArraySchemaSelector)this.arrayCache.getUnchecked((Object)digest);
        int size = instance.size();
        for (int index = 0; index < size; ++index) {
            tree.append(JsonPointer.empty().append(index));
            for (JsonPointer ptr : selector.selectSchemas(index)) {
                schemaTree.append(ptr);
                this.process(report, input);
                schemaTree.pop();
            }
            tree.pop();
        }
    }

    private void processObject(ProcessingReport report, ValidationData input) throws ProcessingException {
        JsonSchemaTree schemaTree = input.getSchema();
        JsonTree tree = input.getInstance();
        JsonNode schema = schemaTree.getCurrentNode();
        JsonNode instance = tree.getCurrentNode();
        JsonNode digest = ObjectSchemaDigester.getInstance().digest(schema);
        ObjectSchemaSelector selector = (ObjectSchemaSelector)this.objectCache.getUnchecked((Object)digest);
        ArrayList fields = Lists.newArrayList((Iterator)instance.fieldNames());
        Collections.sort(fields);
        for (String field : fields) {
            tree.append(JsonPointer.empty().append(field));
            for (JsonPointer ptr : selector.selectSchemas(field)) {
                schemaTree.append(ptr);
                this.process(report, input);
                schemaTree.pop();
            }
            tree.pop();
        }
    }

    private static CacheLoader<JsonNode, ArraySchemaSelector> arrayLoader() {
        return new CacheLoader<JsonNode, ArraySchemaSelector>(){

            public ArraySchemaSelector load(JsonNode key) throws Exception {
                return new ArraySchemaSelector(key);
            }
        };
    }

    private static CacheLoader<JsonNode, ObjectSchemaSelector> objectLoader() {
        return new CacheLoader<JsonNode, ObjectSchemaSelector>(){

            public ObjectSchemaSelector load(JsonNode key) throws Exception {
                return new ObjectSchemaSelector(key);
            }
        };
    }
}

