/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processing.ref;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.messages.RefProcessingMessages;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.ref.Dereferencing;
import com.github.fge.jsonschema.processing.ref.URIManager;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.schema.SchemaBundle;
import com.github.fge.jsonschema.tree.JsonSchemaTree;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import java.util.concurrent.ExecutionException;

public final class SchemaLoader {
    private final JsonRef namespace;
    private final LoadingCache<URI, JsonNode> cache;
    private final Dereferencing dereferencing;

    public SchemaLoader(final URIManager manager, URI namespace, Dereferencing dereferencing) {
        this.dereferencing = dereferencing;
        this.namespace = JsonRef.fromURI(namespace);
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<URI, JsonNode>(){

            public JsonNode load(URI key) throws ProcessingException {
                return manager.getContent(key);
            }
        });
    }

    public JsonSchemaTree load(JsonNode schema) {
        Preconditions.checkNotNull((Object)schema, (Object)"cannot register null schema");
        return this.dereferencing.newTree(schema);
    }

    public JsonSchemaTree get(URI uri) throws ProcessingException {
        JsonRef ref = this.namespace.resolve(JsonRef.fromURI(uri));
        ProcessingMessage msg = new ProcessingMessage().put("uri", ref);
        if (!ref.isAbsolute()) {
            throw new ProcessingException(msg.msg(RefProcessingMessages.URI_NOT_ABSOLUTE));
        }
        URI realURI = ref.toURI();
        try {
            JsonNode node = (JsonNode)this.cache.get((Object)realURI);
            return this.dereferencing.newTree(ref, node);
        }
        catch (ExecutionException e) {
            throw (ProcessingException)e.getCause();
        }
    }

    public void addBundle(SchemaBundle bundle) {
        this.cache.putAll(bundle.getSchemas());
    }

    public String toString() {
        return this.cache.stats().toString();
    }
}

