/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.syntax.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.old.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.old.syntax.SyntaxChecker;
import com.github.fge.jsonschema.old.syntax.SyntaxValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.base.Functions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class DraftV4TypeSyntaxChecker
extends AbstractSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new DraftV4TypeSyntaxChecker();
    private static final Set<String> VALID_TYPES = FluentIterable.from(EnumSet.allOf(NodeType.class)).transform(Functions.toStringFunction()).toImmutableSet();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private DraftV4TypeSyntaxChecker() {
        super("type", NodeType.ARRAY, NodeType.STRING);
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        JsonNode typeNode = schema.get(this.keyword);
        Message.Builder msg = this.newMsg();
        if (typeNode.isTextual()) {
            DraftV4TypeSyntaxChecker.checkSimpleType(msg, messages, typeNode.textValue());
            return;
        }
        int size = typeNode.size();
        if (size == 0) {
            msg.setMessage("type array must not be empty");
            messages.add(msg.build());
            return;
        }
        HashSet set = Sets.newHashSet();
        for (int index = 0; index < size; ++index) {
            msg.addInfo("index", index);
            JsonNode node = typeNode.get(index);
            NodeType type = NodeType.getNodeType(node);
            if (type != NodeType.STRING) {
                msg.setMessage("incorrect type for type array element").addInfo("found", type).addInfo("expected", NodeType.STRING);
                messages.add(msg.build());
            } else {
                DraftV4TypeSyntaxChecker.checkSimpleType(msg, messages, node.textValue());
            }
            if (set.add(node)) continue;
            msg.clearInfo().setMessage("elements in type array must be unique");
            messages.add(msg.build());
            return;
        }
    }

    private static void checkSimpleType(Message.Builder msg, List<Message> messages, String s) {
        if (!VALID_TYPES.contains(s)) {
            msg.setMessage("unknown simple type").addInfo("value", s).addInfo("valid", VALID_TYPES);
            messages.add(msg.build());
        }
    }
}

