/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.syntax.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.old.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.old.syntax.SyntaxChecker;
import com.github.fge.jsonschema.old.syntax.SyntaxValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class DraftV3DependenciesSyntaxChecker
extends AbstractSyntaxChecker {
    private static final EnumSet<NodeType> VALID_DEPENDENCY_TYPES = EnumSet.of(NodeType.OBJECT, NodeType.ARRAY, NodeType.STRING);
    private static final SyntaxChecker INSTANCE = new DraftV3DependenciesSyntaxChecker();

    private DraftV3DependenciesSyntaxChecker() {
        super("dependencies", NodeType.OBJECT, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        HashSet fields = Sets.newHashSet((Iterator)node.fieldNames());
        block5: for (String field : Ordering.natural().sortedCopy((Iterable)fields)) {
            Message.Builder msg = this.newMsg().addInfo("property", field);
            JsonNode element = node.get(field);
            NodeType type = NodeType.getNodeType(element);
            switch (type) {
                case OBJECT: {
                    validator.validate(messages, element);
                }
                case STRING: {
                    continue block5;
                }
                case ARRAY: {
                    break;
                }
                default: {
                    msg.addInfo("found", type).addInfo("expected", VALID_DEPENDENCY_TYPES).setMessage("dependency value has incorrect type");
                    messages.add(msg.build());
                    continue block5;
                }
            }
            int size = element.size();
            for (int index = 0; index < size; ++index) {
                type = NodeType.getNodeType(element.get(index));
                if (type == NodeType.STRING) continue;
                msg.addInfo("index", index).addInfo("found", type).addInfo("expected", NodeType.STRING).setMessage("array dependency value has incorrect type");
                messages.add(msg.build());
            }
        }
    }
}

