/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.syntax.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.old.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.old.syntax.SyntaxChecker;
import com.github.fge.jsonschema.old.syntax.SyntaxValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.util.equivalence.JsonSchemaEquivalence;
import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;

public final class EnumSyntaxChecker
extends AbstractSyntaxChecker {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonSchemaEquivalence.getInstance();
    private static final SyntaxChecker INSTANCE = new EnumSyntaxChecker();

    private EnumSyntaxChecker() {
        super("enum", NodeType.ARRAY, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        JsonNode enumNode = schema.get(this.keyword);
        Message.Builder msg = this.newMsg();
        if (enumNode.size() == 0) {
            msg.setMessage("an enum array must have at least one element");
            messages.add(msg.build());
            return;
        }
        HashSet values = Sets.newHashSet();
        for (JsonNode value : enumNode) {
            if (values.add(EQUIVALENCE.wrap((Object)value))) continue;
            msg.setMessage("elements in the array are not unique");
            messages.add(msg.build());
            return;
        }
    }
}

