/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.old.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.old.syntax.SyntaxValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.util.NodeType;
import java.util.List;

public final class PositiveIntegerSyntaxChecker
extends AbstractSyntaxChecker {
    public PositiveIntegerSyntaxChecker(String keyword) {
        super(keyword, NodeType.INTEGER, new NodeType[0]);
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        Message.Builder msg = this.newMsg().addInfo("found", node);
        if (!node.canConvertToInt()) {
            msg.setMessage("integer value is too large").addInfo("max", Integer.MAX_VALUE);
            messages.add(msg.build());
            return;
        }
        if (node.intValue() < 0) {
            messages.add(msg.setMessage("value cannot be negative").build());
        }
    }
}

