/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.keyword.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.old.keyword.KeywordValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.util.jackson.JacksonUtils;
import com.github.fge.jsonschema.validator.JsonValidator;
import com.github.fge.jsonschema.validator.ValidationContext;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class DraftV3DependenciesKeywordValidator
extends KeywordValidator {
    private static final Joiner DEP_JOINER = Joiner.on((String)"; ").skipNulls();
    private final SetMultimap<String, String> simple;
    private final Map<String, JsonNode> schemas;

    public DraftV3DependenciesKeywordValidator(JsonNode schema) {
        super("dependencies", NodeType.OBJECT);
        Map<String, JsonNode> fields = JacksonUtils.asMap(schema.get("dependencies"));
        ImmutableMap.Builder schemaBuilder = ImmutableMap.builder();
        ImmutableSetMultimap.Builder simpleBuilder = ImmutableSetMultimap.builder();
        for (Map.Entry<String, JsonNode> entry : fields.entrySet()) {
            String key = entry.getKey();
            JsonNode value = entry.getValue();
            if (value.isObject()) {
                schemaBuilder.put((Object)key, (Object)value);
                continue;
            }
            if (value.size() == 0) {
                simpleBuilder.put((Object)key, (Object)value.textValue());
                continue;
            }
            for (JsonNode element : value) {
                simpleBuilder.put((Object)key, (Object)element.textValue());
            }
        }
        this.schemas = schemaBuilder.build();
        this.simple = simpleBuilder.build();
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        HashSet fields = Sets.newHashSet((Iterator)instance.fieldNames());
        TreeSet fieldDeps = Sets.newTreeSet((Iterable)fields);
        fieldDeps.retainAll(this.simple.keySet());
        for (String field : fieldDeps) {
            this.computeSimpleDep(field, fields, report);
        }
        HashMap schemaDeps = Maps.newHashMap(this.schemas);
        schemaDeps.keySet().retainAll(fields);
        if (schemaDeps.isEmpty()) {
            return;
        }
        for (JsonNode subSchema : schemaDeps.values()) {
            JsonValidator validator = context.newValidator(subSchema);
            validator.validate(context, report, instance);
            if (!report.hasFatalError()) continue;
            return;
        }
    }

    private void computeSimpleDep(String field, Set<String> fields, ValidationReport report) {
        Set required = this.simple.get((Object)field);
        Sets.SetView missing = Sets.difference((Set)required, fields);
        if (missing.isEmpty()) {
            return;
        }
        Message.Builder msg = this.newMsg().setMessage("missing property dependencies").addInfo("property", field).addInfo("missing", Ordering.natural().sortedCopy((Iterable)missing)).addInfo("expected", Ordering.natural().sortedCopy((Iterable)required));
        report.addMessage(msg.build());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.keyword).append(": ");
        if (this.simple.isEmpty() && this.schemas.isEmpty()) {
            return sb.append("none??").toString();
        }
        DEP_JOINER.appendTo(sb, this.simple.isEmpty() ? null : this.simple, (Object)this.schemasToString(), new Object[0]);
        return sb.toString();
    }

    private String schemasToString() {
        if (this.schemas.isEmpty()) {
            return null;
        }
        return "further schema validations for properties " + this.schemas.keySet();
    }
}

