/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.keyword.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.old.keyword.KeywordValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.util.RhinoHelper;
import com.github.fge.jsonschema.validator.ValidationContext;

public final class PatternKeywordValidator
extends KeywordValidator {
    private final String regex;

    public PatternKeywordValidator(JsonNode schema) {
        super("pattern", NodeType.STRING);
        this.regex = schema.get(this.keyword).textValue();
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        if (RhinoHelper.regMatch(this.regex, instance.textValue())) {
            return;
        }
        Message.Builder msg = this.newMsg().addInfo("regex", this.regex).addInfo("string", instance).setMessage("ECMA 262 regex does not match input string");
        report.addMessage(msg.build());
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.regex;
    }
}

