/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.JsonSchemaTree;
import com.github.fge.jsonschema.util.NodeType;
import java.util.Collection;
import java.util.EnumSet;

public abstract class AbstractSyntaxChecker
implements SyntaxChecker {
    protected final String keyword;
    protected final EnumSet<NodeType> types;

    protected AbstractSyntaxChecker(String keyword, NodeType first, NodeType ... other) {
        this.keyword = keyword;
        this.types = EnumSet.of(first, other);
    }

    @Override
    public final EnumSet<NodeType> getValidTypes() {
        return EnumSet.copyOf(this.types);
    }

    @Override
    public final void checkSyntax(Collection<JsonPointer> pointers, ProcessingReport report, JsonSchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree);
        NodeType type = NodeType.getNodeType(node);
        if (!this.types.contains((Object)type)) {
            report.error(this.newMsg(tree, SyntaxMessages.INCORRECT_TYPE).put("expected", this.types).put("found", type));
            return;
        }
        this.checkValue(pointers, report, tree);
    }

    protected abstract void checkValue(Collection<JsonPointer> var1, ProcessingReport var2, JsonSchemaTree var3) throws ProcessingException;

    protected final <T> ProcessingMessage newMsg(JsonSchemaTree tree, T msg) {
        return new ProcessingMessage().put("domain", "syntax").put("schema", tree).put("keyword", this.keyword).msg(msg);
    }

    protected final JsonNode getNode(JsonSchemaTree tree) {
        return tree.getCurrentNode().get(this.keyword);
    }
}

