/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.schema.SchemaContext;
import com.github.fge.jsonschema.schema.SchemaNode;
import com.github.fge.jsonschema.util.jackson.JacksonUtils;
import com.github.fge.jsonschema.validator.JsonValidator;
import com.github.fge.jsonschema.validator.JsonValidatorCache;
import com.google.common.collect.Queues;
import java.net.URI;
import java.util.Deque;

public final class ValidationContext {
    private static final SchemaContext DUMMY_CONTEXT = new SchemaContext(URI.create("#"), (JsonNode)JacksonUtils.nodeFactory().nullNode()){

        @Override
        public boolean contains(JsonRef other) {
            throw new RuntimeException("How did I get there??");
        }

        @Override
        public JsonNode resolve(JsonRef ref) {
            throw new RuntimeException("How did I get there??");
        }
    };
    private final JsonValidatorCache cache;
    private final Deque<SchemaContext> contextQueue = Queues.newArrayDeque();
    private SchemaContext currentContext = DUMMY_CONTEXT;

    public ValidationContext(JsonValidatorCache cache) {
        this.cache = cache;
    }

    void pushContext(SchemaContext context) {
        this.contextQueue.push(this.currentContext);
        this.currentContext = context;
    }

    void popContext() {
        this.currentContext = this.contextQueue.pop();
    }

    public FormatAttribute getFormat(String fmt) {
        return this.cache.getFormatAttributes().get(fmt);
    }

    public JsonValidator newValidator(JsonNode node) {
        SchemaNode schemaNode = new SchemaNode(this.currentContext, node);
        return this.cache.getValidator(schemaNode);
    }

    public String toString() {
        return "current: " + this.currentContext;
    }
}

