/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.tree.JsonSchemaTree;
import com.github.fge.jsonschema.util.NodeType;
import java.math.BigDecimal;
import java.util.Collection;

public final class DivisorSyntaxChecker
extends AbstractSyntaxChecker {
    public DivisorSyntaxChecker(String keyword) {
        super(keyword, NodeType.INTEGER, NodeType.NUMBER);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, ProcessingReport report, JsonSchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree);
        BigDecimal divisor = node.decimalValue();
        if (divisor.compareTo(BigDecimal.ZERO) <= 0) {
            report.error(this.newMsg(tree, SyntaxMessages.ILLEGAL_DIVISOR).put("found", node));
        }
    }
}

