/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.examples;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.examples.ExampleBase;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.metaschema.BuiltinSchemas;
import com.github.fge.jsonschema.metaschema.MetaSchema;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import java.io.IOException;
import java.util.UUID;

public final class Example8
extends ExampleBase {
    public static void main(String ... args) throws IOException {
        JsonNode customSchema = Example8.loadResource("/custom-fmt.json");
        JsonNode good = Example8.loadResource("/custom-fmt-good.json");
        JsonNode bad = Example8.loadResource("/custom-fmt-bad.json");
        MetaSchema metaSchema = MetaSchema.basedOn(BuiltinSchemas.DRAFTV3_CORE).addFormatAttribute("uuid", UUIDFormatAttribute.getInstance()).build();
        JsonSchemaFactory factory = JsonSchemaFactory.builder().addMetaSchema(metaSchema, true).build();
        JsonSchema schema = factory.fromSchema(customSchema);
        ValidationReport report = schema.validate(good);
        Example8.printReport(report);
        report = schema.validate(bad);
        Example8.printReport(report);
    }

    private static final class UUIDFormatAttribute
    extends FormatAttribute {
        private static final FormatAttribute INSTANCE = new UUIDFormatAttribute();

        private UUIDFormatAttribute() {
            super(NodeType.STRING, new NodeType[0]);
        }

        public static FormatAttribute getInstance() {
            return INSTANCE;
        }

        @Override
        public void checkValue(String fmt, ValidationReport report, JsonNode value) {
            try {
                UUID.fromString(value.textValue());
            }
            catch (IllegalArgumentException ignored) {
                Message.Builder msg = UUIDFormatAttribute.newMsg(fmt).addInfo("value", value).setMessage("string is not a valid UUID");
                report.addMessage(msg.build());
            }
        }
    }
}

