/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library;

import com.github.fge.jsonschema.exceptions.unchecked.ValidationConfigurationError;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.keyword.digest.Digester;
import com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.library.DictionaryBuilder;
import com.github.fge.jsonschema.library.Keyword;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.messages.ValidationConfigurationMessages;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.util.Thawed;
import java.lang.reflect.Constructor;

public final class LibraryBuilder
implements Thawed<Library> {
    final DictionaryBuilder<SyntaxChecker> syntaxCheckers;
    final DictionaryBuilder<Digester> digesters;
    final DictionaryBuilder<Constructor<? extends KeywordValidator>> validators;
    final DictionaryBuilder<FormatAttribute> formatAttributes;

    LibraryBuilder() {
        this.syntaxCheckers = Dictionary.newBuilder();
        this.digesters = Dictionary.newBuilder();
        this.validators = Dictionary.newBuilder();
        this.formatAttributes = Dictionary.newBuilder();
    }

    LibraryBuilder(Library library) {
        this.syntaxCheckers = library.syntaxCheckers.thaw();
        this.digesters = library.digesters.thaw();
        this.validators = library.validators.thaw();
        this.formatAttributes = library.formatAttributes.thaw();
    }

    LibraryBuilder addKeyword(Keyword keyword) {
        if (keyword == null) {
            throw new ValidationConfigurationError(new ProcessingMessage().message((Object)ValidationConfigurationMessages.NULL_KEYWORD));
        }
        String name = keyword.name;
        this.removeKeyword(name);
        this.syntaxCheckers.addEntry(name, (Object)keyword.syntaxChecker);
        if (keyword.constructor != null) {
            this.digesters.addEntry(name, (Object)keyword.digester);
            this.validators.addEntry(name, keyword.constructor);
        }
        return this;
    }

    LibraryBuilder removeKeyword(String name) {
        if (name == null) {
            throw new ValidationConfigurationError(new ProcessingMessage().message((Object)ValidationConfigurationMessages.NULL_NAME));
        }
        this.syntaxCheckers.removeEntry(name);
        this.digesters.removeEntry(name);
        this.validators.removeEntry(name);
        return this;
    }

    LibraryBuilder addFormatAttribute(String name, FormatAttribute attribute) {
        this.removeFormatAttribute(name);
        if (attribute == null) {
            throw new ValidationConfigurationError(new ProcessingMessage().message((Object)ValidationConfigurationMessages.NULL_ATTRIBUTE));
        }
        this.formatAttributes.addEntry(name, (Object)attribute);
        return this;
    }

    LibraryBuilder removeFormatAttribute(String name) {
        if (name == null) {
            throw new ValidationConfigurationError(new ProcessingMessage().message((Object)ValidationConfigurationMessages.NULL_FORMAT));
        }
        this.formatAttributes.removeEntry(name);
        return this;
    }

    public Library freeze() {
        return new Library(this);
    }
}

