/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.syntax.helpers;

import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.keyword.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.NodeType;
import java.util.Collection;

public final class SchemaArraySyntaxChecker
extends AbstractSyntaxChecker {
    public SchemaArraySyntaxChecker(String keyword) {
        super(keyword, NodeType.ARRAY, new NodeType[0]);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        int size = this.getNode(tree).size();
        if (size == 0) {
            report.error(this.newMsg(tree, SyntaxMessages.EMPTY_ARRAY));
            return;
        }
        for (int index = 0; index < size; ++index) {
            pointers.add(JsonPointer.of((Object)this.keyword, (Object[])new Object[]{index}));
        }
    }
}

