/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.messages.FormatMessages;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.net.InternetDomainName;

public final class HostnameAttribute
extends AbstractFormatAttribute {
    private static final FormatAttribute INSTANCE = new HostnameAttribute();

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    private HostnameAttribute() {
        super("host-name", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void validate(ProcessingReport report, FullData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        try {
            InternetDomainName.from((String)instance.textValue());
        }
        catch (IllegalArgumentException ignored) {
            report.error(this.newMsg(data, FormatMessages.INVALID_HOSTNAME));
        }
    }
}

