/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.PositiveIntegerKeywordValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.validator.ValidationContext;

public final class MinItemsKeywordValidator
extends PositiveIntegerKeywordValidator {
    public MinItemsKeywordValidator(JsonNode schema) {
        super("minItems", schema, NodeType.ARRAY);
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        if (instance.size() >= this.intValue) {
            return;
        }
        Message.Builder msg = this.newMsg().addInfo(this.keyword, this.intValue).addInfo("found", instance.size()).setMessage("not enough elements in array");
        report.addMessage(msg.build());
    }

    @Override
    public boolean alwaysTrue() {
        return this.intValue == 0;
    }
}

