/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.report.Domain;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import java.util.EnumSet;

public abstract class FormatAttribute {
    private final EnumSet<NodeType> typeSet;

    protected FormatAttribute(NodeType first, NodeType ... other) {
        this.typeSet = EnumSet.of(first, other);
    }

    public final void validate(String fmt, ValidationReport report, JsonNode value) {
        if (!this.typeSet.contains((Object)NodeType.getNodeType(value))) {
            return;
        }
        this.checkValue(fmt, report, value);
    }

    public abstract void checkValue(String var1, ValidationReport var2, JsonNode var3);

    protected static Message.Builder newMsg(String fmt) {
        return Domain.VALIDATION.newMessage().setKeyword("format").addInfo("format", fmt);
    }
}

