/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.draftv4.SchemaArrayKeywordValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.validator.JsonValidator;
import com.github.fge.jsonschema.validator.ValidationContext;

public final class AllOfKeywordValidator
extends SchemaArrayKeywordValidator {
    public AllOfKeywordValidator(JsonNode schema) {
        super("allOf", schema);
    }

    @Override
    protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        ValidationReport subReport = report.copy();
        for (JsonNode subSchema : this.subSchemas) {
            JsonValidator validator = context.newValidator(subSchema);
            validator.validate(context, subReport, instance);
            if (subReport.isSuccess()) continue;
            report.mergeWith(subReport);
            Message.Builder msg = this.newMsg().setMessage("instance does not validate against all schemas");
            report.addMessage(msg.build());
        }
    }

    @Override
    public String toString() {
        return "all of " + this.subSchemas.size() + " schema(s)";
    }
}

