/*
 * Copyright (c) 2014, Francis Galiegue (fgaliegue@gmail.com)
 *
 * This software is dual-licensed under:
 *
 * - the Lesser General Public License (LGPL) version 3.0 or, at your option, any
 *   later version;
 * - the Apache Software License (ASL) version 2.0.
 *
 * The text of this file and of both licenses is available at the root of this
 * project or, if you have the jar distribution, in directory META-INF/, under
 * the names LGPL-3.0.txt and ASL-2.0.txt respectively.
 *
 * Direct link to the sources:
 *
 * - LGPL 3.0: https://www.gnu.org/licenses/lgpl-3.0.txt
 * - ASL 2.0: http://www.apache.org/licenses/LICENSE-2.0.txt
 */

package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.jsonpointer.JsonPointer;

/**
 * Difference operation types. Add, remove, and replace operations
 * are directly generated by node comparison. Move operations are
 * the result of factorized add and remove operations.
 */
enum DiffOperation
{
    ADD("add"),
    REMOVE("remove"),
    REPLACE("replace"),
    MOVE("move"),
    COPY("copy"),
    ;

    private final String opName;

    DiffOperation(final String opName)
    {
        this.opName = opName;
    }

    ObjectNode newOp(final JsonPointer ptr)
    {
        final ObjectNode ret = JacksonUtils.nodeFactory().objectNode();
        ret.put("op", opName);
        ret.put("path", ptr.toString());
        return ret;
    }

    @Override
    public String toString()
    {
        return opName;
    }
}
