/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.transform.process;

import com.github.fge.grappa.annotations.Label;
import com.github.fge.grappa.rules.Rule;
import com.github.fge.grappa.transform.CodeBlock;
import com.github.fge.grappa.transform.base.ParserClassNode;
import com.github.fge.grappa.transform.base.RuleMethod;
import com.github.fge.grappa.transform.process.RuleMethodProcessor;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.qmx.jitescript.util.CodegenUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;

public final class LabellingGenerator
implements RuleMethodProcessor {
    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Objects.requireNonNull(classNode, "classNode");
        Objects.requireNonNull(method, "method");
        return !method.hasDontLabelAnnotation();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        Objects.requireNonNull(classNode, "classNode");
        Objects.requireNonNull(method, "method");
        Preconditions.checkState((!method.isSuperMethod() ? 1 : 0) != 0);
        InsnList instructions = method.instructions;
        AbstractInsnNode retInsn = instructions.getLast();
        while (retInsn.getOpcode() != 176) {
            retInsn = retInsn.getPrevious();
        }
        LabelNode label = new LabelNode();
        CodeBlock block = CodeBlock.newCodeBlock().dup().ifnull(label).ldc(LabellingGenerator.getLabelText(method)).invokeinterface(CodegenUtils.p(Rule.class), "label", CodegenUtils.sig(Rule.class, (Class[])new Class[]{String.class})).label(label);
        instructions.insertBefore(retInsn, block.getInstructionList());
    }

    public static String getLabelText(RuleMethod method) {
        if (method.visibleAnnotations == null) {
            return method.name;
        }
        for (Object annotationObj : method.visibleAnnotations) {
            AnnotationNode annotation = (AnnotationNode)annotationObj;
            if (!annotation.desc.equals(CodegenUtils.ci(Label.class)) || annotation.values == null) continue;
            Preconditions.checkState((boolean)"value".equals(annotation.values.get(0)));
            String labelValue = (String)annotation.values.get(1);
            return labelValue.isEmpty() ? method.name : labelValue;
        }
        return method.name;
    }
}

