/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.transform.process;

import com.github.fge.grappa.misc.AsmUtils;
import com.github.fge.grappa.transform.CodeBlock;
import com.github.fge.grappa.transform.base.ParserClassNode;
import com.github.fge.grappa.transform.base.RuleMethod;
import com.github.fge.grappa.transform.process.RuleMethodProcessor;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.InsnList;

public final class BodyWithSuperCallReplacer
implements RuleMethodProcessor {
    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Objects.requireNonNull(classNode, "classNode");
        Objects.requireNonNull(method, "method");
        return !method.isBodyRewritten() && method.getOwnerClass() == classNode.getParentClass() && method.getLocalVarVariables().isEmpty();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        Objects.requireNonNull(classNode, "classNode");
        Objects.requireNonNull(method, "method");
        String parentDesc = classNode.getParentType().getInternalName();
        InsnList argumentLoaders = AsmUtils.createArgumentLoaders(method.desc);
        CodeBlock block = CodeBlock.newCodeBlock().aload(0).addAll(argumentLoaders).invokespecial(parentDesc, method.name, method.desc).areturn();
        method.instructions.clear();
        method.instructions.add(block.getInstructionList());
    }
}

