/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.transform.generate;

import com.github.fge.grappa.transform.base.InstructionGraphNode;
import com.github.fge.grappa.transform.base.InstructionGroup;
import com.github.fge.grappa.transform.base.ParserClassNode;
import com.github.fge.grappa.transform.base.RuleMethod;
import com.github.fge.grappa.transform.process.GroupClassGenerator;
import com.github.fge.grappa.transform.runtime.BaseVarInit;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.qmx.jitescript.util.CodegenUtils;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class VarInitClassGenerator
extends GroupClassGenerator {
    public VarInitClassGenerator(boolean forceCodeBuilding) {
        super(forceCodeBuilding);
    }

    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Objects.requireNonNull(method, "method");
        return method.containsVars();
    }

    @Override
    protected boolean appliesTo(InstructionGraphNode group) {
        return group.isVarInitRoot();
    }

    @Override
    protected Type getBaseType() {
        return Type.getType(BaseVarInit.class);
    }

    @Override
    protected void generateMethod(InstructionGroup group, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "get", CodegenUtils.sig(Object.class, (Class[])new Class[0]), null, null);
        VarInitClassGenerator.convertXLoads(group);
        group.getInstructions().accept(mv);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
    }
}

