/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.support;

import com.github.fge.grappa.misc.Reference;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import java.util.Deque;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Var<T>
extends Reference<T> {
    private final Supplier<T> supplier;
    private final Deque<T> stack = Lists.newLinkedList();
    private int level;
    private String name;

    public Var() {
        this((Object)null);
    }

    public Var(@Nullable T value) {
        super(value);
        this.supplier = Suppliers.ofInstance(value);
    }

    public Var(@Nonnull Supplier<T> supplier) {
        this.supplier = Objects.requireNonNull(supplier);
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final int getLevel() {
        return this.level;
    }

    public final boolean enterFrame() {
        if (this.level++ > 0) {
            this.stack.add(this.get());
        }
        return this.set(this.supplier.get());
    }

    public final boolean exitFrame() {
        if (--this.level > 0) {
            this.set(this.stack.removeLast());
        }
        return true;
    }

    public final String toString() {
        return (String)Optional.fromNullable((Object)this.name).or((Object)super.toString());
    }
}

