/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.matchers.unicode;

import com.github.fge.grappa.matchers.MatcherType;
import com.github.fge.grappa.matchers.base.AbstractMatcher;
import com.github.fge.grappa.run.context.MatcherContext;

public final class CodePointRangeMatcher
extends AbstractMatcher {
    private final int low;
    private final int high;

    public CodePointRangeMatcher(int low, int high) {
        super(String.format("U+%04X-U+%04X", low, high));
        this.low = low;
        this.high = high;
    }

    @Override
    public MatcherType getType() {
        return MatcherType.TERMINAL;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        int codePoint = context.getInputBuffer().codePointAt(context.getCurrentIndex());
        if (codePoint < this.low || codePoint > this.high) {
            return false;
        }
        context.advanceIndex(codePoint < 65536 ? 1 : 2);
        return true;
    }
}

