/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.matchers.trie;

import com.github.fge.grappa.matchers.MatcherType;
import com.github.fge.grappa.matchers.base.AbstractMatcher;
import com.github.fge.grappa.matchers.trie.Trie;
import com.github.fge.grappa.run.context.MatcherContext;
import com.google.common.annotations.Beta;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
@Beta
public final class TrieMatcher
extends AbstractMatcher {
    private final Trie trie;

    public TrieMatcher(Trie trie) {
        super("trie(" + Objects.requireNonNull(trie).getNrWords() + " strings)");
        this.trie = trie;
    }

    @Override
    public MatcherType getType() {
        return MatcherType.TERMINAL;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        int maxLength = this.trie.getMaxLength();
        int index = context.getCurrentIndex();
        String input = context.getInputBuffer().extract(index, index + maxLength);
        int ret = this.trie.search(input);
        if (ret == -1) {
            return false;
        }
        context.advanceIndex(ret);
        return true;
    }
}

