/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.matchers.delegate;

import com.github.fge.grappa.exceptions.GrappaException;
import com.github.fge.grappa.matchers.MatcherType;
import com.github.fge.grappa.matchers.base.CustomDefaultLabelMatcher;
import com.github.fge.grappa.matchers.base.Matcher;
import com.github.fge.grappa.rules.Rule;
import com.github.fge.grappa.run.context.MatcherContext;
import java.util.Objects;

public final class OneOrMoreMatcher
extends CustomDefaultLabelMatcher<OneOrMoreMatcher> {
    private final Matcher subMatcher = (Matcher)this.getChildren().get(0);

    public OneOrMoreMatcher(Rule subRule) {
        super(Objects.requireNonNull(subRule, "subRule"), "oneOrMore");
    }

    @Override
    public MatcherType getType() {
        return MatcherType.COMPOSITE;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        boolean matched = this.subMatcher.getSubContext(context).runMatcher();
        if (!matched) {
            return false;
        }
        int beforeMatch = context.getCurrentIndex();
        while (this.subMatcher.getSubContext(context).runMatcher()) {
            int afterMatch = context.getCurrentIndex();
            if (afterMatch != beforeMatch) {
                beforeMatch = afterMatch;
                continue;
            }
            throw new GrappaException("The inner rule of oneOrMore rule '" + this.getLabel() + "' must not allow empty matches");
        }
        return true;
    }
}

