/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.matchers.base;

import com.github.fge.grappa.matchers.base.Matcher;
import com.github.fge.grappa.misc.ImmutableGraphNode;
import com.github.fge.grappa.rules.Rule;
import com.github.fge.grappa.run.context.MatcherContext;
import com.google.common.collect.ImmutableList;
import java.util.Objects;

public abstract class AbstractMatcher
extends ImmutableGraphNode<Matcher>
implements Matcher,
Cloneable {
    private String label;

    protected AbstractMatcher(String label) {
        this(new Rule[0], label);
    }

    protected AbstractMatcher(Rule subRule, String label) {
        this(new Rule[]{Objects.requireNonNull(subRule, "subRule")}, label);
    }

    protected AbstractMatcher(Rule[] subRules, String label) {
        super(ImmutableList.copyOf((Object[])AbstractMatcher.toMatchers(Objects.requireNonNull(subRules))));
        this.label = label;
    }

    private static Matcher[] toMatchers(Rule ... subRules) {
        Matcher[] matchers = new Matcher[subRules.length];
        for (int i = 0; i < subRules.length; ++i) {
            matchers[i] = (Matcher)subRules[i];
        }
        return matchers;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean hasCustomLabel() {
        return true;
    }

    public final String toString() {
        return this.getLabel();
    }

    @Override
    public final AbstractMatcher label(String label) {
        if (Objects.equals(label, this.label)) {
            return this;
        }
        AbstractMatcher clone = this.createClone();
        clone.label = label;
        return clone;
    }

    @Override
    public <V> MatcherContext<V> getSubContext(MatcherContext<V> context) {
        return context.getSubContext(this);
    }

    private AbstractMatcher createClone() {
        try {
            return (AbstractMatcher)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

