/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.matchers;

import com.github.fge.grappa.matchers.MatcherType;
import com.github.fge.grappa.matchers.base.AbstractMatcher;
import com.github.fge.grappa.run.context.MatcherContext;
import com.github.fge.grappa.support.Characters;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class AnyOfMatcher
extends AbstractMatcher {
    private final Characters characters;

    public AnyOfMatcher(Characters characters) {
        super(Objects.requireNonNull(characters, "characters").toString());
        Preconditions.checkArgument((!characters.equals(Characters.NONE) ? 1 : 0) != 0);
        this.characters = characters;
    }

    @Override
    public MatcherType getType() {
        return MatcherType.TERMINAL;
    }

    public Characters getCharacters() {
        return this.characters;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        if (!this.characters.contains(context.getCurrentChar())) {
            return false;
        }
        context.advanceIndex(1);
        return true;
    }
}

