/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency.puml;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class PumlEdgeInfo {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String begin;
    private String end;
    private String color;
    private String label;

    PumlEdgeInfo() {
    }

    @JsonCreator
    public PumlEdgeInfo(@JsonProperty(value="begin") String begin, @JsonProperty(value="end") String end, @JsonProperty(value="color") String color, @JsonProperty(value="label") String label) {
        this.begin = begin;
        this.end = end;
        this.color = color;
        this.label = label;
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    public String getBegin() {
        return this.begin;
    }

    public String getEnd() {
        return this.end;
    }

    public String getColor() {
        return this.color;
    }

    public String getLabel() {
        return this.label;
    }

    PumlEdgeInfo withBegin(String begin) {
        this.begin = begin;
        return this;
    }

    PumlEdgeInfo withEnd(String end) {
        this.end = end;
        return this;
    }

    PumlEdgeInfo withColor(String color) {
        this.color = color;
        return this;
    }

    PumlEdgeInfo withLabel(String label) {
        this.label = label;
        return this;
    }

    public static PumlEdgeInfo parse(String serialized) {
        try {
            return (PumlEdgeInfo)OBJECT_MAPPER.readValue(serialized, PumlEdgeInfo.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot parse edge info from: " + serialized, e);
        }
    }

    public String toString() {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Cannot serialize edge info. ", e);
        }
    }
}

