/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.mpns.notifications;

import com.notnoop.mpns.DeliveryClass;
import com.notnoop.mpns.MpnsNotification;
import com.notnoop.mpns.internal.Utilities;
import com.notnoop.mpns.notifications.AbstractNotificationBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconicTileNotification
implements MpnsNotification {
    private final Builder builder;
    private final List<? extends Map.Entry<String, String>> headers;

    protected IconicTileNotification(Builder builder, List<? extends Map.Entry<String, String>> headers) {
        this.builder = builder;
        this.headers = headers;
    }

    @Override
    public byte[] getRequestBody() {
        return this.builder.toByteArray();
    }

    @Override
    public List<? extends Map.Entry<String, String>> getHttpHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends AbstractNotificationBuilder<Builder, IconicTileNotification> {
        private String tileId;
        private boolean isClear;
        private String smallIconImage;
        private String iconImage;
        private String wideContent1;
        private String wideContent2;
        private String wideContent3;
        private int count;
        private String title;
        private String backgroundColor;

        public Builder() {
            super("token");
            this.contentType(Utilities.XML_CONTENT_TYPE);
        }

        public Builder tileId(String tileId) {
            this.tileId = tileId;
            return this;
        }

        public Builder isClear(boolean clear) {
            this.isClear = clear;
            return this;
        }

        public Builder smallIconImage(String smallIconImage) {
            this.smallIconImage = smallIconImage;
            return this;
        }

        public Builder iconImage(String iconImage) {
            this.iconImage = iconImage;
            return this;
        }

        public Builder wideContent1(String wideContent1) {
            this.wideContent1 = wideContent1;
            return this;
        }

        public Builder wideContent2(String wideContent2) {
            this.wideContent2 = wideContent2;
            return this;
        }

        public Builder wideContent3(String wideContent3) {
            this.wideContent3 = wideContent3;
            return this;
        }

        public Builder count(int count) {
            this.count = count;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        @Override
        protected int deliveryValueOf(DeliveryClass delivery) {
            return Utilities.getTileDelivery(delivery);
        }

        @Override
        public IconicTileNotification build() {
            return new IconicTileNotification(this, this.headers);
        }

        protected byte[] toByteArray() {
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            sb.append("<wp:Notification xmlns:wp=\"WPNotification\">");
            sb.append("<wp:Tile");
            if (this.tileId != null) {
                sb.append(" Id=\"");
                sb.append(this.tileId);
                sb.append("\"");
            }
            sb.append(" Template=\"IconicTile\">");
            if (this.isClear) {
                sb.append(Utilities.xmlElementClear("SmallIconImage", this.smallIconImage));
            } else {
                sb.append(Utilities.xmlElement("SmallIconImage", this.smallIconImage));
            }
            sb.append(Utilities.xmlElementClear("IconImage", this.iconImage));
            sb.append(Utilities.xmlElementClear("WideContent1", this.wideContent1));
            sb.append(Utilities.xmlElementClear("WideContent2", this.wideContent2));
            sb.append(Utilities.xmlElementClear("WideContent3", this.wideContent3));
            sb.append(Utilities.xmlElementClear("Count", "" + this.count));
            sb.append(Utilities.xmlElementClear("Title", this.title));
            sb.append(Utilities.xmlElementClear("BackgroundColor", this.backgroundColor));
            sb.append("</wp:Tile>");
            sb.append("</wp:Notification>");
            return Utilities.toUTF8(sb.toString());
        }
    }
}

