/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.mpns.internal;

import com.notnoop.mpns.DeliveryClass;
import com.notnoop.mpns.MpnsDelegate;
import com.notnoop.mpns.MpnsNotification;
import com.notnoop.mpns.MpnsResponse;
import java.io.UnsupportedEncodingException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utilities {
    private static final Logger LOG = LoggerFactory.getLogger(Utilities.class);
    public static String XML_CONTENT_TYPE = "text/xml";
    private static MpnsResponse[] logicalResponses = MpnsResponse.values();

    private Utilities() {
        throw new AssertionError((Object)"Uninstantiable class");
    }

    public static ThreadSafeClientConnManager poolManager(int maxConnections) {
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager();
        cm.setMaxTotal(maxConnections);
        cm.setDefaultMaxPerRoute(maxConnections);
        return cm;
    }

    public static String ifNonNull(Object cond, String value) {
        return cond != null ? value : "";
    }

    public static String xmlElement(String name, String content) {
        return Utilities.xmlElement(name, content, false);
    }

    public static String xmlElementClear(String name, String content) {
        return Utilities.xmlElement(name, content, true);
    }

    private static String xmlElement(String name, String content, boolean isClear) {
        if (content == null || "".equals(content.trim())) {
            return "";
        }
        StringBuilder sb = new StringBuilder(500);
        sb.append("<wp:").append(name);
        if (isClear) {
            sb.append(" Action=\"Clear\"");
        }
        sb.append(">");
        sb.append(Utilities.escapeXml(content));
        sb.append("</wp:").append(name).append(">");
        return sb.toString();
    }

    public static String escapeXml(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(value.length());
        block7: for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static byte[] toUTF8(String content) {
        try {
            return content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"The world is coming to an end!  No UTF-8 support");
        }
    }

    private static String headerValue(HttpResponse response, String name) {
        Header header = response.getFirstHeader(name);
        return header == null ? null : header.getValue();
    }

    public static MpnsResponse logicalResponseFor(HttpResponse response) {
        for (MpnsResponse r : logicalResponses) {
            if (r.getResponseCode() != response.getStatusLine().getStatusCode() || r.getNotificationStatus() != null && !r.getNotificationStatus().equals(Utilities.headerValue(response, "X-NotificationStatus")) || r.getDeviceConnectionStatus() != null && !r.getDeviceConnectionStatus().equals(Utilities.headerValue(response, "X-DeviceConnectionStatus")) || r.getSubscriptionStatus() != null && !r.getSubscriptionStatus().equals(Utilities.headerValue(response, "X-SubscriptionStatus"))) continue;
            return r;
        }
        LOG.error("Unmatched error code - Notification status: " + Utilities.headerValue(response, "X-NotificationStatus") + ", Connection status: " + Utilities.headerValue(response, "X-DeviceConnectionStatus") + ", Subscription status: " + Utilities.headerValue(response, "X-SubscriptionStatus") + ", Status code: " + Integer.toString(response.getStatusLine().getStatusCode()));
        return MpnsResponse.UNDEFINED;
    }

    public static void fireDelegate(MpnsNotification message, HttpResponse response, MpnsDelegate delegate, String subscriptionUri) {
        if (delegate != null) {
            MpnsResponse r = Utilities.logicalResponseFor(response);
            if (r.isSuccessful()) {
                delegate.messageSent(message, r, subscriptionUri);
            } else {
                delegate.messageFailed(message, r, subscriptionUri);
            }
        }
    }

    public static int getTileDelivery(DeliveryClass delivery) {
        if (delivery == null) {
            delivery = DeliveryClass.IMMEDIATELY;
        }
        switch (delivery) {
            case IMMEDIATELY: {
                return 1;
            }
            case WITHIN_450: {
                return 11;
            }
            case WITHIN_900: {
                return 21;
            }
        }
        return 1;
    }
}

