/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.mpns;

import com.notnoop.mpns.MpnsDelegate;
import com.notnoop.mpns.MpnsService;
import com.notnoop.mpns.internal.AbstractMpnsService;
import com.notnoop.mpns.internal.MpnsPooledService;
import com.notnoop.mpns.internal.MpnsQueuedService;
import com.notnoop.mpns.internal.MpnsServiceImpl;
import com.notnoop.mpns.internal.Utilities;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class MpnsServiceBuilder {
    private int pooledMax = 1;
    private ExecutorService executor = null;
    private boolean isQueued = false;
    private HttpHost proxy = null;
    private HttpClient httpClient = null;
    private int timeout = -1;
    private MpnsDelegate delegate;
    private SecurityInfo securityInfo;

    public MpnsServiceBuilder withHttpProxy(String host, int port) {
        this.proxy = new HttpHost(host, port);
        return this;
    }

    public MpnsServiceBuilder withHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public MpnsServiceBuilder asPool(int maxConnections) {
        return this.asPool(Executors.newFixedThreadPool(maxConnections), maxConnections);
    }

    public MpnsServiceBuilder asPool(ExecutorService executor, int maxConnections) {
        this.pooledMax = maxConnections;
        this.executor = executor;
        return this;
    }

    public MpnsServiceBuilder asQueued() {
        this.isQueued = true;
        return this;
    }

    public MpnsServiceBuilder asAuthenticated(SecurityInfo securityInfo) {
        this.securityInfo = securityInfo;
        return this;
    }

    public MpnsServiceBuilder timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public MpnsServiceBuilder delegate(MpnsDelegate delegate) {
        this.delegate = delegate;
        return this;
    }

    public MpnsService build() {
        this.checkInitialization();
        Object client = this.httpClient != null ? this.httpClient : (this.pooledMax == 1 ? new DefaultHttpClient() : new DefaultHttpClient((ClientConnectionManager)Utilities.poolManager(this.pooledMax)));
        if (this.proxy != null) {
            client.getParams().setParameter("http.route.default-proxy", (Object)this.proxy);
        }
        if (this.securityInfo != null) {
            try {
                KeyStore keyStore = null;
                keyStore = this.securityInfo.getProvider() == null ? KeyStore.getInstance(this.securityInfo.getName()) : KeyStore.getInstance(this.securityInfo.getName(), this.securityInfo.getProvider());
                keyStore.load(new ByteArrayInputStream(this.securityInfo.getCert()), this.securityInfo.getPassword().toCharArray());
                KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmfactory.init(keyStore, this.securityInfo.getPassword().toCharArray());
                KeyManager[] km = kmfactory.getKeyManagers();
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(km, null, null);
                SSLSocketFactory sslSocketFactory = new SSLSocketFactory(sslContext);
                Scheme https = new Scheme("https", 443, (SchemeSocketFactory)sslSocketFactory);
                client.getConnectionManager().getSchemeRegistry().register(https);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (this.timeout > 0) {
            HttpParams params = client.getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)this.timeout);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.timeout);
        }
        AbstractMpnsService service = this.pooledMax == 1 ? new MpnsServiceImpl((HttpClient)client, this.delegate) : new MpnsPooledService((HttpClient)client, this.executor, this.delegate);
        if (this.isQueued) {
            service = new MpnsQueuedService(service);
        }
        service.start();
        return service;
    }

    private void checkInitialization() {
        if (this.pooledMax != 1 && this.executor == null) {
            throw new IllegalStateException("Executor service is required for pooled connections");
        }
    }

    public static class SecurityInfo {
        private byte[] cert;
        private String password;
        private String name;
        private String provider;

        public SecurityInfo(byte[] cert, String password, String securityName, String securityProvider) {
            if (cert == null || cert.length == 0 || password == null || "".equals(password.trim()) || securityName == null || "".equals(securityName.trim())) {
                throw new IllegalArgumentException("Please provide certificate, password, and name");
            }
            this.cert = Arrays.copyOf(cert, cert.length);
            this.password = password;
            this.name = securityName;
            this.provider = securityProvider;
        }

        public byte[] getCert() {
            return this.cert;
        }

        public String getPassword() {
            return this.password;
        }

        public String getName() {
            return this.name;
        }

        public String getProvider() {
            return this.provider;
        }
    }
}

