/*
 * Decompiled with CFR 0.152.
 */
package com.github.fanzezhen.security.facade.traditional;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.github.fanzezhen.common.enums.auth.RoleEnum;
import com.github.fanzezhen.pojo.dto.SysPermissionDto;
import com.github.fanzezhen.security.facade.UserDetailsServiceFacade;
import com.github.fanzezhen.security.model.SysUserDetail;
import com.github.fanzezhen.security.property.SecurityProjectProperty;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.tomcat.util.buf.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.cas.authentication.CasAssertionAuthenticationToken;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class UserDetailsServiceFacadeImpl
implements UserDetailsServiceFacade {
    private static final Logger log = LoggerFactory.getLogger(UserDetailsServiceFacadeImpl.class);
    @Resource
    private SecurityProjectProperty securityProjectProperty;
    @Resource(name="sysUserServiceImpl")
    private IService sysUserService;
    @Resource(name="sysRoleServiceImpl")
    private IService sysRoleService;
    @Resource(name="sysPermissionServiceImpl")
    private IService sysPermissionService;
    @Resource(name="sysRolePermissionServiceImpl")
    private IService sysRolePermissionService;

    public UserDetails loadUserDetails(CasAssertionAuthenticationToken casAssertionAuthenticationToken) throws UsernameNotFoundException {
        String username = casAssertionAuthenticationToken.getName();
        log.info("\u5f53\u524d\u7684\u7528\u6237\u540d\u662f\uff1a" + username);
        SysUserDetail userInfo = this.loadUserByUsername(username);
        log.info(userInfo.toString());
        return userInfo;
    }

    public SysUserDetail loadUserByUsername(String username) throws UsernameNotFoundException {
        Map sysUserMap = this.sysUserService.getMap(org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.securityProjectProperty.APP_CODE) ? (Wrapper)new QueryWrapper().eq((Object)"username", (Object)username) : (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"username", (Object)username)).eq((Object)"app_code", (Object)this.securityProjectProperty.APP_CODE));
        if (sysUserMap != null) {
            HashSet<CallSite> grantedAuthorityNameSet = new HashSet<CallSite>();
            HashSet<String> sysRoleIdSet = new HashSet<String>();
            HashSet<String> roleNameSet = new HashSet<String>();
            HashSet<Integer> roleTypeSet = new HashSet<Integer>();
            List sysRoleMapList = this.sysRoleService.listMaps(org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.securityProjectProperty.APP_CODE) ? (Wrapper)new QueryWrapper().inSql((Object)"id", "select role_id from sys_user_role where user_id = '" + sysUserMap.get("id") + "'") : (Wrapper)((QueryWrapper)new QueryWrapper().inSql((Object)"id", "select role_id from sys_user_role where user_id = '" + sysUserMap.get("id") + "'")).eq((Object)"app_code", (Object)this.securityProjectProperty.APP_CODE));
            for (Map sysRoleMap : sysRoleMapList) {
                sysRoleIdSet.add(String.valueOf(sysRoleMap.get("id")));
                roleNameSet.add(String.valueOf(sysRoleMap.get("roleName")));
                roleTypeSet.add((Integer)sysRoleMap.get("roleType"));
            }
            if (!sysRoleIdSet.isEmpty()) {
                for (Object sysPermissionId : this.sysRolePermissionService.listObjs((Wrapper)(roleTypeSet.contains(RoleEnum.RoleTypeEnum.SPECIAL_ADMIN.getType()) ? new QueryWrapper().select(new String[]{"permission_id"}) : (Wrapper)new QueryWrapper().select(new String[]{"permission_id"}).in((Object)"role_id", sysRoleIdSet)))) {
                    grantedAuthorityNameSet.add((CallSite)((Object)("permission_" + sysPermissionId)));
                }
            }
            grantedAuthorityNameSet.addAll(RoleEnum.RoleTypeEnum.securityRoleTypeCodeSetByType(roleTypeSet));
            HashSet grantedAuthorities = new HashSet(AuthorityUtils.commaSeparatedStringToAuthorityList((String)StringUtils.join(grantedAuthorityNameSet, (char)',')));
            SysUserDetail sysUserDetail = new SysUserDetail(sysUserMap, grantedAuthorities);
            sysUserDetail.setRoleIds(sysRoleIdSet);
            sysUserDetail.setRoleNames(roleNameSet);
            sysUserDetail.setRoleTypes(roleTypeSet);
            return sysUserDetail;
        }
        throw new UsernameNotFoundException("user: " + username + " do not exist!");
    }

    @Override
    public List<SysPermissionDto> listAllPermissionDto(String appCode) {
        ArrayList<SysPermissionDto> sysPermissionDtoList = new ArrayList<SysPermissionDto>();
        List permissionMapList = this.sysPermissionService.listMaps((Wrapper)new QueryWrapper().eq((Object)"app_code", (Object)this.securityProjectProperty.APP_CODE));
        if (permissionMapList == null) {
            return sysPermissionDtoList;
        }
        for (Map map : permissionMapList) {
            sysPermissionDtoList.add((SysPermissionDto)JSON.parseObject((String)JSON.toJSONString((Object)map), SysPermissionDto.class));
        }
        return sysPermissionDtoList;
    }
}

